<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN"
"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html>

<head>
<title>Shockvoice Query</title>
<link rel="stylesheet" type="text/css" href="query.css"/>
</head>

<?
// ---------------------------------------------------------
//
//	SHOCKVOICE QUERY SCRIPT V0.9.0
//
//	CHANGE THESE SETTINGS TO FIT YOUR SERVER
//
// ---------------------------------------------------------

// Which host does your SV server run on
$HOSTNAME = "localhost";

// The server's query port. This is NOT the port you connect
// your client to. If you don't know it, leave it as it is,
// it's probably ok like that. You can find the query port configuration
// in your servers config.xml
$PORT = "8010";

// The server id of your server. In a default installation you can 
// leave 1. For a different server you can check your server list
// in the client to find out the ID of the server you want to query
$SERVER_ID = "1";

// set this to true in case you want to use WGET to retrieve 
// the query information. Try that in case you experience problems
// with the PHP functions. Make sure you have WGET installed and 
// the write permissions on the temp directory are okay
$USE_WGET = false;

// the directory where WGET will store the XML.
$TEMP_PATH = "temp";

// ---------------------------------------------------------
// Implementation: Don't touch it except if you find a bug :)
// ---------------------------------------------------------

function startElement($parser, $name, $attrs)
{
	global $info;
	global $queryoutput;
	global $depth;
	global $infotag;

	if ($name == "INFO")
	{
		$queryoutput .= "<table>";
		$info = true;
		return;
	}

	if ($info == true)
	{
		$infotag = $name;
		return;
	}

	for ($i = 0; $i < $depth[$parser]; $i++) 
	{
		$queryoutput .= "&nbsp;&nbsp;&nbsp;&nbsp;";
	}
	
	$name_attr = "?";
	$status_attr = "online";
	$passwd_attr = "False";
	$type_attr = "1";
	$usertype_attr = "user";

	if (count($attrs)) 
	{
    		foreach ($attrs as $k => $v) 
    		{
        		if ($k == "NAME")
				$name_attr = $v;
			else if ($k == "TYPE")
				$type_attr = $v;
			else if ($k == "PASSWORD")
				$passwd_attr = $v;
			else if ($k == "STATUS")
				$status_attr = $v;
			else if ($k == "ANONYMOUS")
				$usertype_attr = ($v == "True") ? "anon" : $usertype_attr;
			else if ($k == "ADMIN")
				$usertype_attr = ($v == "True") ? "admin" : $usertype_attr;
    		}
	}

	if ($name == "CHANNEL")
	{
		$img = "";

		if ($type_attr == "0")
		{
			$img = "channel_temp";
		}	
		else if ($type_attr == "1")
		{
			$img = "channel";
		}	
		else if ($type_attr == "2")
		{
			$img = "channel_admin";
		}	

		if ($passwd_attr == "True")
		{
			$img .= "_locked";
		}

		$queryoutput .= "<img src='channel/$img.png' border=0>&nbsp;$name_attr<br>\n";
	}
	if ($name == "VOICEGROUP")
	{
		$img = "voicegroup";
		if ($passwd_attr == "True")
			$img .= "_locked";
		
		$queryoutput .= "<img src='voicegroup/$img.png' border=0>&nbsp;$name_attr<br>\n";
	}
	if ($name == "VOICEGROUPUSER")
	{
		$queryoutput .= "<img src='voicegroup/user.png' border=0>&nbsp;$name_attr<br>\n";
	}
	if ($name == "USER")
	{
		$img = "";
		switch ((int)$status_attr)
		{
		case 0: $img = "online"; break;
		case 1: $img = "away"; break;
		case 2: $img = "notavailable"; break;
		case 3: $img = "occupied"; break;
		case 4: $img = "donotdisturb"; break;
		case 5: $img = "freeforchat"; break;
		case 6: $img = "onthephone"; break;
		case 7: $img = "outtolunch"; break;
		}
		
		if ($usertype_attr == "admin")
			$name_attr = "<b>$name_attr</b>";
		else if ($usertype_attr == "anon")
			$name_attr = "<font color='#808080'>$name_attr</font>";
		
		$queryoutput .= "<img src='status/$img.png' border=0>&nbsp;$name_attr<br>\n";
	}

	$depth[$parser]++;
}

function endElement($parser, $name)
{
	global $info;
	global $depth;
	global $queryoutput;

	if ($info == true)
	{
		if ($name == "INFO")
		{	
			$queryoutput .= "</table>";
			$info = false;
		}
	}
	else
	{
		$depth[$parser]--;
	}
}

function charData($parser, $data)
{
	global $queryoutput;
	global $infotag;
	global $info;

	if ($info == true && $infotag != "" && trim($data) != "")
		$queryoutput .= "<tr><td><b>$infotag</b></td><td>$data</td></tr>";
}

function queryServer($hostname, $serverid, $port)
{
	global $queryoutput;
    
	$queryoutput = "";
	$xml = file_get_contents("http://" . $hostname . ":" . $port . "/" . $serverid);
	$xml_parser = xml_parser_create();
	xml_set_element_handler($xml_parser, "startElement", "endElement");

	if ($xml != "")
	{
	
		if (!xml_parse($xml_parser, $xml, true)) 
		{
			die(sprintf("XML error: %s at line %d",
				xml_error_string(xml_get_error_code($xml_parser)),
				xml_get_current_line_number($xml_parser)));
		}
	
		xml_parser_free($xml_parser);
		return $queryoutput;
	}
	else
	{
		xml_parser_free($xml_parser);
		return "Server does not respond!";
	}
}

function queryServerWget($hostname, $serverid, $port, $temppath)
{
	global $queryoutput;

	$queryoutput = "";
	$xml = "";
	$url = "http://" . $hostname . ":" . $port . "/" . $serverid;
	
	$rand = rand(0, 10000000);
	system("wget $url -t 1 -T 5 -q -O $temppath/query$rand.xml --ignore-length");
	$xml = file_get_contents("$temppath/query$rand.xml");
	unlink("$temppath/query$rand.xml");
	
	if ($xml != "")
	{
		$xml_parser = xml_parser_create();
		xml_set_element_handler($xml_parser, "startElement", "endElement");
		xml_set_character_data_handler($xml_parser, "charData");
		
		if (!xml_parse($xml_parser, $xml, true)) {
			die(sprintf("XML error: %s at line %d",
						xml_error_string(xml_get_error_code($xml_parser)),
						xml_get_current_line_number($xml_parser)));
		}
		
		xml_parser_free($xml_parser);

		return $queryoutput;
	}
	else
	{
		return "Server does not respond!";
	}
}

if ($USE_WGET)
    echo queryServerWget($HOSTNAME, $SERVER_ID, $PORT, $TEMP_PATH);
else
    echo queryServer($HOSTNAME, $SERVER_ID, $PORT);

?>

</body>
</html>