
CREATE TABLE [plugin_sv_vmail_mails] (
[mail_id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,
[subject] VARCHAR(50)  NOT NULL,
[quality] INTEGER  NOT NULL,
[user_id] INTEGER  NOT NULL,
[sender_id] INTEGER  NOT NULL,
[size] INTEGER  NOT NULL,
[date] VARCHAR(14)  NOT NULL
);

CREATE TABLE [sv_ban] (
[server_id] INTEGER  NOT NULL,
[ip] VARCHAR(18)  NOT NULL,
[date] VARCHAR(14)  NOT NULL,
[banned_by] INTEGER  NOT NULL,
[reason] VARCHAR(50)  NOT NULL,
[endtime] VARCHAR(14)  NOT NULL,
PRIMARY KEY ([server_id],[ip])
);

CREATE TABLE [sv_channel] (
[id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,
[parent_id] INTEGER  NOT NULL,
[server_id] INTEGER  NOT NULL,
[max_users] INTEGER  NOT NULL,
[name] VARCHAR(50)  NOT NULL,
[topic] VARCHAR(200)  NOT NULL,
[description] TEXT  NOT NULL,
[password] VARCHAR(32)  NOT NULL,
[date_created] VARCHAR(14)  NOT NULL,
[codec] VARCHAR(4)  NOT NULL,
[quality] INTEGER  NOT NULL,
[admin_only] INTEGER  NOT NULL,
[no_anonymous] INTEGER  NOT NULL,
[no_temp_subchannels] INTEGER  NOT NULL,
[no_reg_subchannels] INTEGER  NOT NULL,
[no_admin_subchannels] INTEGER  NOT NULL,
[moderated] INTEGER  NOT NULL,
[hidden] INTEGER  NOT NULL,
[created_by] INTEGER  NOT NULL,
[type] INTEGER  NOT NULL,
[time_to_live] INTEGER  NOT NULL,
[position] INTEGER  NOT NULL,
[role_id] INTEGER  NOT NULL
);

CREATE TABLE [sv_channel_ban] (
[channel_id] INTEGER  NOT NULL,
[user_id] INTEGER  NOT NULL,
[date] VARCHAR(14)  NOT NULL,
[banned_by] INTEGER  NOT NULL,
[reason] VARCHAR(50)  NOT NULL,
[endtime] VARCHAR(14)  NOT NULL,
PRIMARY KEY ([channel_id],[user_id])
);

CREATE TABLE sv_codec (
  id VARCHAR(4) NOT NULL,
  quality INTEGER NOT NULL,
  qualityname VARCHAR(50) NOT NULL,
  server_id INTEGER NOT NULL,
  PRIMARY KEY (id,quality,server_id)
);

CREATE TABLE [sv_config] (
[key] VARCHAR(50)  NULL PRIMARY KEY,
[value] VARCHAR(1000)  NULL
);

CREATE TABLE [sv_file] (
[id] INTEGER  NOT NULL PRIMARY KEY AUTOINCREMENT,
[plugin] VARCHAR(50)  NOT NULL,
[path] VARCHAR(255)  NOT NULL,
[user_id] INTEGER  NOT NULL,
[created] VARCHAR(14)  NOT NULL,
[accessed] VARCHAR(14)  NOT NULL,
[filelen] INTEGER  NOT NULL,
[server_id] INTEGER  NOT NULL
);

CREATE TABLE [sv_permissionlist] (
[id] INTEGER  NOT NULL PRIMARY KEY AUTOINCREMENT,
[name] VARCHAR(5)  NOT NULL,
[type] INTEGER  NOT NULL,
[plugin] VARCHAR(10)  NOT NULL,
[datatype] INTEGER  NOT NULL,
[description] VARCHAR(100)  NOT NULL,
[min_value] INTEGER  NOT NULL,
[max_value] INTEGER  NOT NULL
);

CREATE TABLE [sv_plugin] (
[id] VARCHAR(50)  NOT NULL,
[filequota] INTEGER  NOT NULL,
[server_id] INTEGER  NOT NULL,
[usedquota] INTEGER  NOT NULL,
PRIMARY KEY ([id],[server_id])
);

CREATE TABLE [sv_role] (
[id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,
[name] VARCHAR(50)  NOT NULL,
[server_id] INTEGER  NOT NULL
);

CREATE TABLE [sv_rolepermission] (
[role_id] INTEGER  NOT NULL,
[permission_id] INTEGER  NOT NULL,
[may_execute] INTEGER  NOT NULL,
[may_assign] INTEGER  NOT NULL
);

CREATE TABLE [sv_server] (
[id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,
[name] VARCHAR(50)  NOT NULL,
[description] TEXT  NOT NULL,
[max_users] INTEGER  NOT NULL,
[port] INTEGER  NOT NULL,
[password] VARCHAR(32)  NOT NULL,
[active] INTEGER  NOT NULL,
[date_created] VARCHAR(14)  NOT NULL,
[no_anonymous] INTEGER  NOT NULL,
[homepage_url] VARCHAR(200)  NOT NULL,
[register] INTEGER  NOT NULL,
[list_on_svnetwork] INTEGER  NOT NULL,
[anon_role] INTEGER  NOT NULL,
[reg_role] INTEGER  NOT NULL,
[default_quality] INTEGER  NOT NULL,
[default_codec] VARCHAR(200)  NOT NULL,
[maintenance_mode] INTEGER  NOT NULL,
[maintenance_message] VARCHAR(200)  NOT NULL,
[maintenance_alt_server] VARCHAR(50)  NOT NULL,
[redirect] VARCHAR(50)  NOT NULL,
[redirect_active] INTEGER  NOT NULL,
[banner_url] VARCHAR(200)  NOT NULL,
[banner_link_url] VARCHAR(200)  NOT NULL,
[banner_active] INTEGER  NOT NULL,
[default_channel_id] INTEGER NOT NULL
);

CREATE TABLE [sv_user] (
[id] INTEGER  NOT NULL PRIMARY KEY AUTOINCREMENT,
[name] VARCHAR(50)  NOT NULL,
[password] VARCHAR(32)  NOT NULL,
[date_created] VARCHAR(14)  NOT NULL,
[date_last_online] VARCHAR(14)  NOT NULL,
[is_admin] INTEGER  NOT NULL,
[is_anonymous] INTEGER  NOT NULL,
[nickname] VARCHAR(50)  NOT NULL,
[ip_address] VARCHAR(15)  NOT NULL,
[server_id] INTEGER  NOT NULL,
[active] INTEGER  NOT NULL,
[expires] INTEGER  NOT NULL,
[date_expires] VARCHAR(14)  NOT NULL,
[extauth] INTEGER NOT NULL,
[extsource] VARCHAR(50) NOT NULL,
[email] VARCHAR(50) NOT NULL,
[info] VARCHAR(500) NOT NULL
);

CREATE TABLE [sv_user_role] (
[user_id] INTEGER  NOT NULL,
[role_id] INTEGER  NOT NULL,
[channel_id] INTEGER  NOT NULL,
PRIMARY KEY ([user_id],[role_id],[channel_id])
);

CREATE TABLE [sv_user_server] (
[user_id] INTEGER  NOT NULL,
[server_id] INTEGER  NOT NULL,
PRIMARY KEY ([user_id],[server_id])
);

CREATE TABLE [sv_vchannel] (
[id] INTEGER  NOT NULL PRIMARY KEY AUTOINCREMENT,
[name] VARCHAR(50)  NOT NULL,
[owner_id] INTEGER  NOT NULL,
[server_id] INTEGER  NOT NULL,
[shortcuts] VARCHAR(50)  NOT NULL
);

CREATE TABLE [sv_vchannel_member] (
[vchannel_id] INTEGER  NOT NULL,
[member_id] INTEGER  NOT NULL,
[member_type] INTEGER  NOT NULL,
PRIMARY KEY ([vchannel_id],[member_id],[member_type])
);

CREATE TABLE [sv_voicegroup] (
[id] INTEGER  PRIMARY KEY AUTOINCREMENT NOT NULL,
[channel_id] INTEGER  NOT NULL,
[name] VARCHAR(50)  NOT NULL,
[password] VARCHAR(32)  NOT NULL,
[role_id] INTEGER  NOT NULL,
[created_by] INTEGER  NOT NULL,
[date_created] VARCHAR(14)  NOT NULL,
[moderated] INTEGER  NOT NULL,
[hidden] INTEGER  NOT NULL,
[no_anonymous] INTEGER  NOT NULL,
[admin_only] INTEGER  NOT NULL
);

CREATE TABLE [sv_voicegroupkey] (
[user_id] INTEGER  NOT NULL,
[voicegroup_id] INTEGER  NOT NULL,
[shortcuts] VARCHAR(50)  NOT NULL,
PRIMARY KEY ([user_id],[voicegroup_id])
);


INSERT INTO sv_server (id, name, description, max_users, port, password, active, date_created, no_anonymous, homepage_url, register, list_on_svnetwork, anon_role, reg_role, default_codec, default_quality, maintenance_mode, maintenance_message, maintenance_alt_server, redirect, redirect_active, banner_url, banner_link_url, banner_active) VALUES
  (1,'Mainserver','',256,8040,'',1,'20070101000000',0,'http://www.shockvoice.org',0,0,0,0,'SPEX',8,0,'','','',0,'','',0);

INSERT INTO sv_user (id, name, password, date_created, date_last_online, is_admin, is_anonymous, nickname, ip_address, server_id, active, expires, date_expires, extauth, extsource, email, info) VALUES 
  (1, 'admin', '21232f297a57a5a743894a0e4a801fc3', '20100101000000', '20100101000000', 1, 0, '', '', 0, 1, 0, '20100101000000', 0, '', '', '');

INSERT INTO sv_user_server (user_id, server_id) VALUES
  (1, 1);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES 
  ('sv_chat',0,1,0);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES 
  ('sv_vmail',10485760,1,0);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES 
  ('sv_wboard',0,1,0);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES 
  ('sv_query',0,1,0);

INSERT INTO sv_config (key, value) VALUES 
  ('DB_VERSION','0.9');
