#!/bin/bash
# Shockvoice installer written by
# Andre Liersch
# kobayashi@shockvoice.org
# update 15.03.2010 - additional features in config.xml - added SOAP question
# created on 29.09.2009
# This script is a part of
# the Shockvoice Linux Server 
#set -x

echo "          _____  __                  __                  _"
echo "         / ___/ / /_   ____   _____ / /__ _   __ ____   (_)_____ ___"
echo "         \__ \ / __ \ / __ \ / ___// //_/| | / // __ \ / // ___// _ \ "
echo "        ___/ // / / // /_/ // /__ / ,<   | |/ // /_/ // // /__ /  __/"
echo "       /____//_/ /_/ \____/ \___//_/|_|  |___/ \____//_/ \___/ \___/"

echo ""
echo "                         Shockvoice installscript"
echo ""
echo ""
echo ""
echo ""
echo "This script will create and configure the service_start, service_stop and the config.xml file."
echo "It will try to locate the necessary files from your Mono installation"
echo "Please make sure you have mono installed before running this script."
echo ""
while true
  read -p "Continue? (Y/n): " begi
do

   case "${begi}" in
        Yes|yes|Y|y|"") break 
            ;;
        No|no|N|n) echo "Exiting.. You have to edit the service_start and config.xml script on your own"
                   exit 1 
            ;;
        *) echo "What?"
            ;;
   esac
done

###### define and create service_start and service_stop ######
create_start ()
{
file="service_start"

    echo "Creating startscript" >&2
    cd $appdir
    if [ -e "$file" ]; then    
    mv $file service_start.ORIG
    echo "Found old service_start file renaming it!"
    fi
    touch "$file"
    chmod 0740 "$file"
    cat > "$file" <<EOF
#!/bin/bash
pck=\`netstat -na | grep 8040\`
 echo "Checking whether port 8040 is in use"
if [ -n "\$pck" ]; then
 echo "Please check port 8040 it seems to be in use or comment out next \"exit 1\" line"
# exit 1
fi

 if [ -e "$appdir/sv.lock" ]; then
  echo "Service could not be started. Please check the logfiles."
  exit 1
 fi

export LD_LIBRARY_PATH=$appdir:\${LD_LIBRARY_PATH}
echo "Starting Shockvoice Service using Mono"

if [ -e "$appdir/sv.lock" ]; then
  echo "Please delete $appdir/sv.lock file and start over"
    exit 1
else
  echo "Starting service ..."
fi

$monoversion $serviceexeversion -l:$appdir/sv.lock "$appdir/shockvoice_service.exe"  >/dev/null 2>$appdir/sverrors.log & 
sleep 2
EOF
    create_stop

while true
  read -p "Do you want to create the config.xml file? (Y/n): " creco
do
    case "${creco}" in 
        Yes|yes|Y|y|"") break
            ;;
        No|no|N|n) echo "Exiting.. Use service_start to start the Shockvoice server."
               exit 1
            ;;
        *) echo "What?"
            ;;
   esac
done
    create_config
}

##### END create_start #####


##### create service_stop file #####
create_stop ()
{
file="service_stop"

    echo "Creating stopscript" >&2
    cd $appdir
    if [ -e "$file" ]; then
    mv $file service_stop.ORIG
    echo "Found old service_stop file renaming it!"
    fi
    touch "$file"
    chmod 0740 "$file"
    cat > "$file" <<EOF
#/bin/bash
if [ -e "$appdir/sv.lock" ]; then
    a=\$(cat $appdir/sv.lock)
    test -z \$a || kill -9 \$a
    rm $appdir/sv.lock
    echo "Service stopped"
    exit 1
        else
    echo "Service is not running"
    exit 1
fi
EOF
}
##### END create service_stop #####

##### define and create config.xml #####
create_config ()
{
file1="config.xml"
    
    echo ""
    echo "Creating $file1" >&2
    cd $appdir
    if [ -e "$file1" ]; then
    mv $file1 config.xml.ORIG
    echo "Found old config.xml renaming it!"
    fi
    touch "$file1"
    chmod 0740 "$file1"
    cat > "$file1" <<EOF
<?xml version="1.0"?>
<config>

    <!--
 ########################################################################
     Database settings. Please adjust to your needs
 ########################################################################
    -->

    <!--
        DBTYPE. Must be one of the following:
        mysql, postgres, mssql, sqlite, oledb, odbc
    -->
    <dbtype>sqlite</dbtype>
    <!--
        DBSERVER. The host of the database server.
        for sqlite or oledb enter the sqlite/mdb filename
        for odbc enter the DSN
        {APP} is a placeholder for the application path
    -->
    <dbserver>{APP}shockvoice.s3db</dbserver>
    <!--
        DBNAME: name of the database. leave empty for sqlite or oledb
    -->
    <dbname></dbname>
    <!--
        DBUSER: user to connect to the database with. not used for sqlite or oledb
    -->
    <dbuser></dbuser>
    <!--
        DBPASSWORD: password to connect to the database. not needed for sqlite
    -->
    <dbpassword></dbpassword>

    <!--
    ########################################################################
        Logfile settings. Please adjust to your needs
    ########################################################################
    -->

    <!--
        the path, where logfiles are written to. {APP} is a placeholder for the application path
    -->
    <logpath>{APP}/log</logpath>
    <!--
        The amount of days, after which log files will be deleted
    -->
    <deleteafter>14</deleteafter>
    <!--
        Should log output go to the console?
    -->
    <writeconsole>false</writeconsole>
    <!--
        Write normal text logfiles?
    -->
    <writetext>true</writetext>
    <!--
        Write HTML log files?
    -->
    <writehtml>false</writehtml>
    
    <!--
    ########################################################################
        Plugin config
    ########################################################################
    -->

    <!--
        the port on which the query runs
    -->
    <plugin name="sv_query">
        <queryport>8010</queryport>
        <bindtoip></bindtoip>        
    </plugin>

    <!--
        Eve Online authentication
    -->
    <plugin name="sv_auth_eve">
        <!--
            The EVE api URL to request a character sheet. You can probably leave it like it is as
        -->
        <url>http://api.eve-online.com/char/CharacterSheet.xml.aspx</url>
        <!--
            A comma separated list of corporation IDs, that you want to verify the user is member of before allowing him to log into SV
        -->
        <corpidlist></corpidlist>
    </plugin>

    <!--
        LDAP authentication
    -->
    <plugin name="sv_auth_ldap">
        <!--
            LDAP server URL
        -->
        <ldap_server>LDAP://</ldap_server>
        <!--
            Method to use to connect. Possible values:
            secure, ssl
        -->
        <method>secure</method>
    </plugin>

    <!--
        Forum authentication
    -->
    <plugin name="sv_auth_forum">
        <!--
            Type of forum to which you want to connect. Possible values are:
            vbulletin, smf, wbb3
        -->
        <forumtype></forumtype>
        <!--
            Type of database, the forum uses. Possible values are:
            mysql, postgres, mssql, odbc
        -->
        <dbtype>mysql</dbtype>
        <!--
            Servername of the database system.
        -->
        <dbserver>localhost</dbserver>
        <!--
            Name of the database
        -->
        <dbname></dbname>
        <!--
            Your username for the database
        -->
        <dbuser></dbuser>
        <!--
            Your password for the database
        -->
        <dbpassword></dbpassword>
        <!--
            Table prefix that is used by the forum database.
            Usually values like smf_ vb_ wcf1_
        -->
        <tableprefix></tableprefix>
        <!--
            Configure which forum groups will map to which shockvoice groups.
            Format: <forumgroup>,<svgroup>,<svchannel>;<forumgroup>,<svgroup>,<svchannel>;...
            Example:  1,5,0;5,8,10
            This will map forum group with ID 1 to Shockvoice Group with ID 5 and assign it serverwide (channel 0).
            Also it will map forum group with ID 5 to Shockvoice Group with ID 8 and assign it in channel with ID 10
        -->
        <groupmapping></groupmapping>
        <!--
            Force SV to use exactly the groups that the forum returns (meaning any additional groups in SV will be removed)
        -->
        <exactgroups>false</exactgroups>
    </plugin>

    <!--
    ########################################################################
        Default groups for a newly created server
    ########################################################################
    -->

        <defaultgroup name="Superadmin" base="Serveradmin" automatic="true">
                <permission name="SM" assign="1" execute="1" />
                <permission name="SP" assign="1" execute="1" />
                <permission name="SCD" assign="1" execute="1" />
        </defaultgroup>

        <defaultgroup name="Serveradmin" base="Channeladmin" automatic="true">
                <permission name="SMB" assign="1" execute="1" />
                <permission name="SU" assign="1" execute="1" />
                <permission name="SUM" assign="1" execute="1" />
                <permission name="SUR" assign="1" execute="1" />
                <permission name="SB" assign="1" execute="1" />
                <permission name="SK" assign="1" execute="1" />
                <permission name="SC" assign="1" execute="1" />
                <permission name="SRM" assign="1" execute="1" />
                <permission name="SRA" assign="1" execute="1" />
                <permission name="SJ" assign="1" execute="1" />
                <permission name="SHC" assign="1" execute="1" />
                <permission name="SJP" assign="1" execute="1" />
                <permission name="SJV" assign="1" execute="1" />
                <permission name="SIP" assign="1" execute="1" />
                <permission name="SSM" assign="1" execute="1" />
                <permission name="SIE" assign="1" execute="1" />
                <permission name="STP" assign="1" execute="1" />
        </defaultgroup>

        <defaultgroup name="Channeladmin" base="Reguser" automatic="true">
                <permission name="CC" assign="1" execute="1" />
                <permission name="CB" assign="1" execute="1" />
                <permission name="CK" assign="1" execute="1" />
                <permission name="CMU" assign="1" execute="1" />
                <permission name="CMC" assign="1" execute="1" />
                <permission name="CMD" assign="1" execute="1" />
                <permission name="CV" assign="1" execute="1" />
                <permission name="UV" assign="1" execute="1" />
        </defaultgroup>

        <defaultgroup name="Reguser" base="Anonuser" automatic="true">
                <permission name="UC" assign="1" execute="1" />
                <permission name="UVC" assign="10" execute="10" />
                <permission name="VMAIL" assign="1" execute="1" />
                <permission name="VMQ" assign="1" execute="1" />
                <permission name="WPC" assign="4" execute="4" />
        </defaultgroup>

        <defaultgroup name="Anonuser" automatic="true">
                <permission name="CHAT" assign="1" execute="1" />
                <permission name="WBD" assign="1" execute="1" />
        </defaultgroup>

    <!--
    ########################################################################
        Default channels for a newly created server
    ########################################################################
    -->

        <defaultchannels>
                <channel name="Lounge" admintype="false" noanonymous="false" adminonly="false" moderated="false" hidden="false" topic="" description="" codec="" quality="" />
                <channel name="Administrators" admintype="true" noanonymous="false" adminonly="false" moderated="false" hidden="false" topic="" description="" codec="" quality="">
                        <channel name="Support" admintype="true" noanonymous="false" adminonly="false" moderated="false" hidden="false" topic="" description="" codec="" quality="" />
                        <channel name="Away" admintype="true" noanonymous="false" adminonly="true" moderated="false" hidden="false" topic="" description="" codec="" quality="" />
                        <channel name="Meeting" admintype="true" noanonymous="false" adminonly="true" moderated="false" hidden="false" topic="" description="" codec="" quality="" />
                        <channel name="Hidden" admintype="true" noanonymous="false" adminonly="true" moderated="false" hidden="true" topic="" description="" codec="" quality="" />
                </channel>
                <channel name="Members" admintype="true" noanonymous="true" adminonly="false" moderated="false" hidden="false" topic="" description="" codec="" quality="">
                        <channel name="Gaming" admintype="false" noanonymous="false" adminonly="false" moderated="false" hidden="false" topic="" description="" codec="" quality="" />
                        <channel name="Moderated" admintype="false" noanonymous="false" adminonly="false" moderated="true" hidden="false" topic="" description="" codec="" quality="" />
                </channel>
        </defaultchannels>

    <!--
    ########################################################################
        Do Not change the following values unless you know what you're doing!
    ########################################################################
    -->

    <!--
        Encryption mode: 0=allow user choice,  1=always encrypt,  2=never encrypt
        Enabling this option needs a lot of CPU power!
    -->
    <encryption>0</encryption>
    <!--
        How many days should anonymous accounts be kept in the database?
    -->
    <anonymousttl>7</anonymousttl>
    <!--
        How long in seconds should pass between anonymous user cleanups?
    -->
    <anonymouscheckinterval>3600</anonymouscheckinterval>
    <!--
        how many seconds should pass between ping messages?
    -->
    <pinginterval>20</pinginterval>
    <!--
        how many seconds should pass before a user is kicked after not replying to pings?
    -->
    <pingkickinterval>180</pingkickinterval>
    <!--
        how many seconds should pass between svnetwork registrations?
    -->
    <registerinterval>900</registerinterval>
    <!--
        how many seconds should pass between checks of ban endtimes / automatic ban removal
    -->
    <bancheckinterval>60</bancheckinterval>
    <!--
        should the hosterinterface be started?
    -->
    <hosterinterfaceactive>false</hosterinterfaceactive>
    <!--
        on which IP should the hosterinterface run? Leave empty for all IPs
    -->
    <hosterinterfaceip>127.0.0.1</hosterinterfaceip>
    <!--
        on which TCP port should the hosterinterface run?
    -->
    <hosterinterfaceport>8020</hosterinterfaceport>
    <!--
        should the webservice be started?
    -->
    <webserviceactive>false</webserviceactive>
    <!--
        on which IP should the webservice run? Leave empty for all IPs
    -->
    <webserviceip>127.0.0.1</webserviceip>
    <!--
        on which TCP port should the webservice run?
    -->
    <webserviceport>8080</webserviceport>
    <!--
        how many open non-logged-in TCP connections should the server allow?
    -->
    <maxpendingconnections>32</maxpendingconnections>
    <!--
        how many TCP connection requests are queued before accepted by the server
    -->
    <tcpqueue>4</tcpqueue>
    <!--
        how much time does a client have between connection and kick to authenticate itself in seconds
    -->
    <idlekicktime>10</idlekicktime>
    <!--
        on which IP should the server listen? leave empty for all IP addresses
    -->
    <bindtoip></bindtoip>
    <!--
    Enable debug logging and diagnostics (causes considerable slowdown in performance!)
    -->
    <debugmode>false</debugmode>

</config>
EOF

	erf=0
	while [ "$erf" = "0" ]
	do
	echo "Please enter type of database you want to use. (e.g. sqlite, mysql or postgres): " dbtype
    echo ""
    echo "1. SQLite"
    echo "2. MySQL"
    echo "3. PostgreSQL"
    echo "0. Exit"
    echo ""
    
    while true
     echo -n "Choose: "
     do
        read dbtype
        case "$dbtype" in

        1)  dbtype="SQLite"; break ;;
        
        2)  dbtype="MySQL"; break ;;
    
        3)  dbtype="Postgres"; break ;;

        0)  exit ;;

        *)  echo "Wrong input"
                ;;
        esac
    done

    if [ "$dbtype" = "SQLite" ]; then
       while true
        do 
        read -p "Please enter name of SQLite database: (e.g. shockvoice.s3db) " dbserver
        if [ "$dbserver" = "" ]; then
            echo "Database cannot by empty!"
        else break   
        fi
       done
     elif [ "$dbtype" = "MySQL" ]; then
        read -p "Please enter server which stores the MySQL database for Shockvoice. (e.g. localhost): " dbserver
        read -p "Please enter name of MySQL database: " dbname
        read -p "Please enter username who connects to the database: " dbuser 
        read -s -p "Please enter password for database user: (*hidden*) " dbpassword
     elif [ "$dbtype" = "Postgres" ]; then
        read -p "Please enter server which stores the PostgreSQL database for Shockvoice. (e.g. localhost): " dbserver
        read -p "Please enter name of PostgreSQL database: " dbname
        read -p "Please enter username who connects to the database: " dbuser
        read -s -p "Please enter password for database user: (*hidden*) " dbpassword
    fi
    echo ""
    echo ""
    if [ "$dbtype" = "SQLite" ]; then
        echo "Database type: $dbtype"
        echo "Database name: $dbserver"
     elif [ "$dbtype" = "MySQL" ]; then
        echo "Database type: $dbtype"
        echo "Database server: $dbserver"
        echo "Database name: $dbname"
        echo "Database user: $dbuser"
        echo "Database password: *hidden*"
     elif [ "$dbtype" = "Postgres" ]; then
        echo "Database type: $dbtype"
        echo "Database server: $dbserver"
        echo "Database name: $dbname"
        echo "Database user: $dbuser"
        echo "Database password: *hidden*"
    fi
     #   read -p "Is this Correct? (Y/n): " mach
	
        while true
          read -p "Is this Correct? (Y/n): " mach
         do
            case ${mach} in
                   Yes|yes|Y|y|"") 
		ex -s "config.xml" <<EOI
14;s;^\([ <tab>]*\<dbtype>\).*\(</dbtype>\)$;\1$dbtype\2;
21;s;^\([ <tab>]*\<dbserver>\).*\(</dbserver>\)$;\1$dbserver\2;
25;s;^\([ <tab>]*\<dbname>\).*\(</dbname>\)$;\1$dbname\2;
29;s;^\([ <tab>]*\<dbuser>\).*\(</dbuser>\)$;\1$dbuser\2;
33;s;^\([ <tab>]*\<dbpassword>\).*\(</dbpassword>\)$;\1$dbpassword\2;
w
q
EOI
		if [ "$dbtype" = "MySQL" ]; then
		   echo ""
		   echo "Remember to setup the MySql database and User!"
		fi
		echo ""
        read -p "Do you intend to use the SOAP interface for remote administration? 
Choose 'Yes' to enable the webservice on http://localhost:8080 otherwise choose no here. (y/N): " enableSOAP

            case $enableSOAP in
                Yes|yes|Y|y)
             ex -s "config.xml" <<EOI
%s;^\([ <tab>]*\<webserviceactive>\).*\(</webserviceactive>\)$;\1true\2;
w
q
EOI
             echo "Webservice enabled!"
                ;;
                No|no|N|n|"")
             echo "Webservice disabled!"
                ;;
            esac

        echo ""
	 	echo "Configfile created!"
	 	echo ""
        echo "Use service_start to start the Shockvoice server."
         erf=1
	 	exit 1
                       ;;

                   *) echo ""  
                      echo "Please start over"
                      echo ""
                         erf=0; break
                        ;;
            esac
         done
   done
}
### END create config.xml file###

##### questions #####
here="`pwd`"

while true
    read -p "Do you have unpacked Shockvoice in $here? (Y/n): " woinst 
   do
        case ${woinst} in
           Yes|yes|Y|y|"") 
                    appdir=$here; break
                       ;; 
                No|no|N|n) 
                    read -p "Please enter directory where you have unpacked Shockvoice e.g.(/usr/share/shockvoice): " isin
                        if [ -e "$isin" ]; then
                            echo "Found your folder"
                            echo ""
                            appdir=$isin; break
                          else
                            echo "$isin does not exist. Please check location and start over. Exit"; exit
                        fi
                       ;; 
                        *) echo "What?"
                       ;;               
        esac
   done
while true
    read -p "Do you want to create the service_start and service_stop file? (recommend) (Y/n): " crest
   do
        case ${crest} in 
           Yes|yes|Y|y|"") 
##### searching for needed files #####
mono_ver=`ls -1td /opt/mono* 2>/dev/null | head -1`
mono_in_src=`ls -1td /usr/src/mono* 2>/dev/null | head -1`

export PATH=$mono_ver/bin:$mono_ver/lib/mono/2.0:$mono_in_src/bin:$mono_in_src/lib/mono/2.0:/usr/lib/mono/2.0:/usr/local/lib/mono/2.0:$PATH
   echo "Searching for mono...  "
   echo ""
   mopath=($(which -a mono 2>&1))
if [ $? -eq 0 ]; then
    for i in `seq 0 $(( ${#mopath[*]}-1 ))`
        do
            echo "$i) ${mopath[$i]} Version: `${mopath[$i]} --version | head -n 1| cut -d" " -f5`"
    done
    
   echo ""
   read -p "Which Version do you want to use (0-$((${#mopath[*]}-1 )))? " version
   echo ""
   monoversion=${mopath[$version]}
else
   unset monoversion
fi
    if [ -x "$monoversion" ]; then
        echo "Found mono binary in $monoversion .. good"
        suc=1
    else
        echo "Could not locate mono binary"
        suc=0
        mopath=0
        answ=0
 while [ "$suc" = "0" ]
    do
    echo ""
    read -p "Please enter mono path (e.g. /usr/bin/mono): " altmopath
    echo ""
    echo ""
    echo "$altmopath"
    read -p "Is this correct? (Y/n): " answ
       if [ "$answ" = "y" ] || [ "$answ" = "Y" ] || [ "$answ" = "" ]; then
         if [ -f "$altmopath" ]; then
            echo "Found your file"
            echo ""
            suc=1
          else
            echo "$altmopath is not the required file. Please check location and start over. Exiting"
          fi
        fi
  done

fi

# mono-service.exe
mono_serv_ver=`ls -1td /opt/mono* 2>/dev/null | head -1`
mono_serv_in_src=`ls -1td /usr/src/mono* 2>/dev/null | head -1`    

export PATH=$mono_serv_ver/lib/mono/gac/mono-service/2.0.0.0__0738eb9f132ed756:$mono_serv_in_src/lib/mono/gac/mono-service/2.0.0.0__0738eb9f132ed756:/usr/lib/mono/gac/mono-service/2.0.0.0__0738eb9f132ed756:/usr/local/lib/mono/gac/mono-service/2.0.0.0__0738eb9f132ed756:$PATH
    echo "Locating mono-service.exe..."
    echo""
    sexepath=($(which -a mono-service.exe 2>&1))
if [ $? -eq 0 ]; then
    for i in `seq 0 $(( ${#sexepath[*]}-1 ))`
        do echo "$i) found ${sexepath[$i]}"
     done
    
    echo ""
    echo "Hint: Mono and mono-service.exe should be from the same version!"
    read -p "Which version do you want to use (0-$((${#sexepath[*]}-1 )))? " exeversion
    echo ""
    serviceexeversion=${sexepath[$exeversion]}
else
    unset serviceexeversion
fi
   if [ -x "$serviceexeversion" ]; then
        echo "Applying mono-service.exe... good"
    suc2=1
   else	      
        echo "Could not locate mono-service.exe binary"
	suc2=0
	sexepath=0
	answ=0	
	while [ "$suc2" = "0" ]
	do
	echo ""
	read -p "Please enter path to mono-service.exe (e.g. /usr/lib/mono/2.0/mono-service.exe): " altsexepath
	   echo ""
	   echo ""
	   echo "$altsexepath"
	   read -p "Is this correct? (Y/n): " answ
	     if [ "$answ" = "y" ] || [ "$answ" = "Y" ] || [ "$answ" = "" ]; then 
	       if [ -f "$altsexepath" ]; then
	          echo "Found your file"
 	          echo ""
		  suc2=1
		else
              echo "$altsexepath is not the required file. Please check location and start over. Exiting"
		  exit
	       fi
	     fi
       done
   fi	

       if [ "$suc" = "1" -a "$suc2" = "1" ]; then
           create_start
        else
           echo "You still have wrong paths. Exit!"
        exit
       fi
        exit 1
                      ;;
##### continue CASE
             No|no|N|n)
while true
    read -p "Do you want to create the config.xml file? (Y/n): " creco1
    do
        case "${creco1}" in 
            Yes|yes|Y|y|"") break
                ;;
                 No|no|N|n) echo "Exiting.. Use service_start to start the Shockvoice server."
                     exit 1
                ;;
                         *) echo "What?"
                ;;
        esac
    done

create_config

                     ;;
                     *) echo "What?"
                     ;;  
        esac
   done 
