/****** Object:  Table [dbo].[sv_permissionlist]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_permissionlist](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](5) NOT NULL,
	[type] [int] NOT NULL,
	[plugin] [varchar](10) NOT NULL,
	[datatype] [int] NOT NULL,
	[description] [varchar](100) NOT NULL,
	[min_value] [int] NOT NULL DEFAULT ('0'),
	[max_value] [int] NOT NULL DEFAULT ('1'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_server]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_server](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NULL DEFAULT (NULL),
	[description] [text] NULL,
	[max_users] [int] NULL DEFAULT (NULL),
	[port] [int] NULL DEFAULT (NULL),
	[password] [varchar](32) NULL DEFAULT (NULL),
	[active] [int] NULL DEFAULT (NULL),
	[date_created] [varchar](14) NULL DEFAULT (NULL),
	[no_anonymous] [int] NOT NULL DEFAULT ('0'),
	[homepage_url] [varchar](200) NOT NULL,
	[register] [int] NOT NULL,
	[list_on_svnetwork] [int] NOT NULL,
	[anon_role] [int] NOT NULL,
	[reg_role] [int] NOT NULL,
	[default_quality] [int] NOT NULL,
	[default_codec] [varchar](4) NOT NULL,
	[maintenance_mode] [int] NOT NULL,
	[maintenance_message] [varchar](200) NOT NULL,
	[maintenance_alt_server] [varchar](50) NOT NULL,
	[redirect] [varchar](50) NOT NULL,
	[redirect_active] [int] NOT NULL,
	[banner_url] [varchar](200) NOT NULL,
	[banner_link_url] [varchar](200) NOT NULL,
	[banner_active] [int] NOT NULL,
	[default_channel_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_user]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_user](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[password] [varchar](32) NOT NULL,
	[date_created] [varchar](14) NOT NULL,
	[date_last_online] [varchar](14) NOT NULL,
	[is_admin] [int] NOT NULL DEFAULT ('0'),
	[is_anonymous] [int] NOT NULL DEFAULT ('0'),
	[nickname] [varchar](50) NOT NULL,
	[ip_address] [varchar](15) NOT NULL,
	[server_id] [int] NOT NULL,
	[active] [int] NOT NULL,
	[expires] [int] NOT NULL,
	[date_expires] [varchar](14) NOT NULL,
	[extauth] [int] NOT NULL,
	[extsource] [varchar](50) NOT NULL,
	[email] [varchar](50) NOT NULL,
	[info] [varchar](500) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_rolepermission]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[sv_rolepermission](
	[role_id] [int] NOT NULL,
	[permission_id] [int] NOT NULL,
	[may_execute] [int] NOT NULL,
	[may_assign] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[role_id] ASC,
	[permission_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[sv_user_role]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[sv_user_role](
	[user_id] [int] NOT NULL,
	[role_id] [int] NOT NULL,
	[channel_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[user_id] ASC,
	[role_id] ASC,
	[channel_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[sv_plugin]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_plugin](
	[id] [varchar](50) NOT NULL,
	[filequota] [int] NOT NULL,
	[server_id] [int] NOT NULL,
	[usedquota] [int] NOT NULL DEFAULT ('0'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC,
	[server_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_role]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_role](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[server_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_vchannel]    Script Date: 03/26/2010 14:25:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_vchannel](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[name] [varchar](50) NOT NULL,
	[owner_id] [int] NOT NULL,
	[server_id] [int] NOT NULL,
	[shortcuts] [varchar](50) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_user_server]    Script Date: 03/26/2010 14:25:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[sv_user_server](
	[user_id] [int] NOT NULL,
	[server_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[user_id] ASC,
	[server_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[sv_ban]    Script Date: 03/26/2010 14:25:49 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_ban](
	[server_id] [int] NOT NULL,
	[ip] [varchar](18) NOT NULL,
	[date] [varchar](14) NOT NULL,
	[banned_by] [int] NOT NULL,
	[reason] [varchar](50) NOT NULL,
	[endtime] [varchar](14) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[server_id] ASC,
	[ip] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_channel]    Script Date: 03/26/2010 14:25:49 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_channel](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[parent_id] [int] NOT NULL,
	[server_id] [int] NOT NULL,
	[max_users] [int] NOT NULL DEFAULT ('0'),
	[name] [varchar](50) NOT NULL,
	[topic] [varchar](200) NOT NULL,
	[description] [text] NOT NULL,
	[password] [varchar](32) NOT NULL,
	[date_created] [varchar](14) NOT NULL,
	[codec] [varchar](4) NOT NULL,
	[quality] [int] NOT NULL DEFAULT ('1'),
	[admin_only] [int] NOT NULL DEFAULT ('0'),
	[no_anonymous] [int] NOT NULL DEFAULT ('0'),
	[no_temp_subchannels] [int] NOT NULL DEFAULT ('0'),
	[no_reg_subchannels] [int] NOT NULL DEFAULT ('0'),
	[no_admin_subchannels] [int] NOT NULL DEFAULT ('0'),
	[moderated] [int] NOT NULL DEFAULT ('0'),
	[hidden] [int] NOT NULL DEFAULT ('0'),
	[created_by] [int] NOT NULL DEFAULT ('0'),
	[type] [int] NOT NULL DEFAULT ('1'),
	[time_to_live] [int] NOT NULL DEFAULT ('5'),
	[position] [int] NOT NULL DEFAULT ('0'),
	[role_id] [int] NOT NULL DEFAULT ('0'),
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_codec]    Script Date: 03/26/2010 14:25:50 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_codec](
	[id] [varchar](4) NOT NULL,
	[quality] [int] NOT NULL,
	[qualityname] [varchar](50) NOT NULL,
	[server_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC,
	[quality] ASC,
	[server_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[plugin_sv_vmail_mails]    Script Date: 03/26/2010 14:25:48 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[plugin_sv_vmail_mails](
	[mail_id] [int] IDENTITY(1,1) NOT NULL,
	[subject] [varchar](50) NOT NULL,
	[quality] [int] NOT NULL,
	[user_id] [int] NOT NULL,
	[sender_id] [int] NOT NULL,
	[size] [int] NOT NULL,
	[date] [varchar](14) NOT NULL,
	[unread] [int] NOT NULL DEFAULT ('1'),
PRIMARY KEY CLUSTERED 
(
	[mail_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_file]    Script Date: 03/26/2010 14:25:51 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_file](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[plugin] [varchar](50) NOT NULL,
	[path] [varchar](255) NOT NULL,
	[user_id] [int] NOT NULL,
	[created] [varchar](14) NOT NULL,
	[accessed] [varchar](14) NOT NULL,
	[filelen] [int] NOT NULL,
	[server_id] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[plugin] ASC,
	[path] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_channel_ban]    Script Date: 03/26/2010 14:25:49 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_channel_ban](
	[channel_id] [int] NOT NULL,
	[user_id] [int] NOT NULL,
	[date] [varchar](14) NOT NULL,
	[banned_by] [int] NOT NULL,
	[reason] [varchar](50) NOT NULL,
	[endtime] [varchar](14) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[channel_id] ASC,
	[user_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_voicegroupkey]    Script Date: 03/26/2010 14:25:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_voicegroupkey](
	[user_id] [int] NOT NULL,
	[voicegroup_id] [int] NOT NULL,
	[shortcuts] [varchar](50) NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[user_id] ASC,
	[voicegroup_id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[sv_vchannel_member]    Script Date: 03/26/2010 14:25:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[sv_vchannel_member](
	[vchannel_id] [int] NOT NULL,
	[member_id] [int] NOT NULL,
	[member_type] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[vchannel_id] ASC,
	[member_id] ASC,
	[member_type] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[sv_voicegroup]    Script Date: 03/26/2010 14:25:52 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[sv_voicegroup](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[channel_id] [int] NOT NULL,
	[name] [varchar](50) NOT NULL,
	[password] [varchar](32) NOT NULL,
	[role_id] [int] NOT NULL,
	[created_by] [int] NOT NULL,
	[date_created] [varchar](14) NOT NULL,
	[moderated] [int] NOT NULL,
	[hidden] [int] NOT NULL,
	[no_anonymous] [int] NOT NULL,
	[admin_only] [int] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_PADDING OFF
GO
/****** Object:  ForeignKey [FK_plugin_sv_vmail_mails_sv_user]    Script Date: 03/26/2010 14:25:48 ******/
ALTER TABLE [dbo].[plugin_sv_vmail_mails]  WITH CHECK ADD  CONSTRAINT [FK_plugin_sv_vmail_mails_sv_user] FOREIGN KEY([user_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[plugin_sv_vmail_mails] CHECK CONSTRAINT [FK_plugin_sv_vmail_mails_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_ban_sv_server]    Script Date: 03/26/2010 14:25:49 ******/
ALTER TABLE [dbo].[sv_ban]  WITH CHECK ADD  CONSTRAINT [FK_sv_ban_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_ban] CHECK CONSTRAINT [FK_sv_ban_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_channel_sv_server]    Script Date: 03/26/2010 14:25:49 ******/
ALTER TABLE [dbo].[sv_channel]  WITH CHECK ADD  CONSTRAINT [FK_sv_channel_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_channel] CHECK CONSTRAINT [FK_sv_channel_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_channel_ban_sv_channel]    Script Date: 03/26/2010 14:25:49 ******/
ALTER TABLE [dbo].[sv_channel_ban]  WITH CHECK ADD  CONSTRAINT [FK_sv_channel_ban_sv_channel] FOREIGN KEY([channel_id])
REFERENCES [dbo].[sv_channel] ([id])
GO
ALTER TABLE [dbo].[sv_channel_ban] CHECK CONSTRAINT [FK_sv_channel_ban_sv_channel]
GO
/****** Object:  ForeignKey [FK_sv_channel_ban_sv_user]    Script Date: 03/26/2010 14:25:49 ******/
ALTER TABLE [dbo].[sv_channel_ban]  WITH CHECK ADD  CONSTRAINT [FK_sv_channel_ban_sv_user] FOREIGN KEY([user_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[sv_channel_ban] CHECK CONSTRAINT [FK_sv_channel_ban_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_codec_sv_server]    Script Date: 03/26/2010 14:25:50 ******/
ALTER TABLE [dbo].[sv_codec]  WITH CHECK ADD  CONSTRAINT [FK_sv_codec_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_codec] CHECK CONSTRAINT [FK_sv_codec_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_file_sv_user]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_file]  WITH CHECK ADD  CONSTRAINT [FK_sv_file_sv_user] FOREIGN KEY([user_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[sv_file] CHECK CONSTRAINT [FK_sv_file_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_plugin_sv_server]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_plugin]  WITH CHECK ADD  CONSTRAINT [FK_sv_plugin_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_plugin] CHECK CONSTRAINT [FK_sv_plugin_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_role_sv_server]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_role]  WITH CHECK ADD  CONSTRAINT [FK_sv_role_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_role] CHECK CONSTRAINT [FK_sv_role_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_rolepermission_sv_permissionlist]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_rolepermission]  WITH CHECK ADD  CONSTRAINT [FK_sv_rolepermission_sv_permissionlist] FOREIGN KEY([permission_id])
REFERENCES [dbo].[sv_permissionlist] ([id])
GO
ALTER TABLE [dbo].[sv_rolepermission] CHECK CONSTRAINT [FK_sv_rolepermission_sv_permissionlist]
GO
/****** Object:  ForeignKey [FK_sv_rolepermission_sv_role]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_rolepermission]  WITH CHECK ADD  CONSTRAINT [FK_sv_rolepermission_sv_role] FOREIGN KEY([role_id])
REFERENCES [dbo].[sv_role] ([id])
GO
ALTER TABLE [dbo].[sv_rolepermission] CHECK CONSTRAINT [FK_sv_rolepermission_sv_role]
GO
/****** Object:  ForeignKey [FK_sv_user_role_sv_role]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_user_role]  WITH CHECK ADD  CONSTRAINT [FK_sv_user_role_sv_role] FOREIGN KEY([role_id])
REFERENCES [dbo].[sv_role] ([id])
GO
ALTER TABLE [dbo].[sv_user_role] CHECK CONSTRAINT [FK_sv_user_role_sv_role]
GO
/****** Object:  ForeignKey [FK_sv_user_role_sv_user]    Script Date: 03/26/2010 14:25:51 ******/
ALTER TABLE [dbo].[sv_user_role]  WITH CHECK ADD  CONSTRAINT [FK_sv_user_role_sv_user] FOREIGN KEY([user_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[sv_user_role] CHECK CONSTRAINT [FK_sv_user_role_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_user_server_sv_server]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_user_server]  WITH CHECK ADD  CONSTRAINT [FK_sv_user_server_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_user_server] CHECK CONSTRAINT [FK_sv_user_server_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_user_server_sv_user]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_user_server]  WITH CHECK ADD  CONSTRAINT [FK_sv_user_server_sv_user] FOREIGN KEY([user_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[sv_user_server] CHECK CONSTRAINT [FK_sv_user_server_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_vchannel_sv_server]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_vchannel]  WITH CHECK ADD  CONSTRAINT [FK_sv_vchannel_sv_server] FOREIGN KEY([server_id])
REFERENCES [dbo].[sv_server] ([id])
GO
ALTER TABLE [dbo].[sv_vchannel] CHECK CONSTRAINT [FK_sv_vchannel_sv_server]
GO
/****** Object:  ForeignKey [FK_sv_vchannel_sv_user]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_vchannel]  WITH CHECK ADD  CONSTRAINT [FK_sv_vchannel_sv_user] FOREIGN KEY([owner_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[sv_vchannel] CHECK CONSTRAINT [FK_sv_vchannel_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_vchannel_member_sv_vchannel]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_vchannel_member]  WITH CHECK ADD  CONSTRAINT [FK_sv_vchannel_member_sv_vchannel] FOREIGN KEY([vchannel_id])
REFERENCES [dbo].[sv_vchannel] ([id])
GO
ALTER TABLE [dbo].[sv_vchannel_member] CHECK CONSTRAINT [FK_sv_vchannel_member_sv_vchannel]
GO
/****** Object:  ForeignKey [FK_sv_voicegroup_sv_channel]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_voicegroup]  WITH CHECK ADD  CONSTRAINT [FK_sv_voicegroup_sv_channel] FOREIGN KEY([channel_id])
REFERENCES [dbo].[sv_channel] ([id])
GO
ALTER TABLE [dbo].[sv_voicegroup] CHECK CONSTRAINT [FK_sv_voicegroup_sv_channel]
GO
/****** Object:  ForeignKey [FK_sv_voicegroupkey_sv_user]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_voicegroupkey]  WITH CHECK ADD  CONSTRAINT [FK_sv_voicegroupkey_sv_user] FOREIGN KEY([user_id])
REFERENCES [dbo].[sv_user] ([id])
GO
ALTER TABLE [dbo].[sv_voicegroupkey] CHECK CONSTRAINT [FK_sv_voicegroupkey_sv_user]
GO
/****** Object:  ForeignKey [FK_sv_voicegroupkey_sv_voicegroup]    Script Date: 03/26/2010 14:25:52 ******/
ALTER TABLE [dbo].[sv_voicegroupkey]  WITH CHECK ADD  CONSTRAINT [FK_sv_voicegroupkey_sv_voicegroup] FOREIGN KEY([voicegroup_id])
REFERENCES [dbo].[sv_voicegroup] ([id])
GO
ALTER TABLE [dbo].[sv_voicegroupkey] CHECK CONSTRAINT [FK_sv_voicegroupkey_sv_voicegroup]
GO



SET IDENTITY_INSERT sv_server ON;
INSERT INTO sv_server (id, name, description, max_users, port, password, active, date_created, no_anonymous, homepage_url, register, list_on_svnetwork, anon_role, reg_role, default_codec, default_quality, maintenance_mode, maintenance_message, maintenance_alt_server, redirect, redirect_active, banner_url, banner_link_url, banner_active) VALUES 
  (1,'Mainserver','',256,8040,'',1,'20070101000000',0,'http://www.shockvoice.org',0,0,0,0,'SPEX',8,0,'','','',0,'','',0);
SET IDENTITY_INSERT sv_server OFF;

SET IDENTITY_INSERT sv_user ON;
INSERT INTO sv_user (id, name, password, date_created, date_last_online, is_admin, is_anonymous, nickname, ip_address, server_id, active, expires, date_expires, extauth, extsource, email, info) VALUES 
  (1, 'admin', '21232f297a57a5a743894a0e4a801fc3', '20100101000000', '20100101000000', 1, 0, '', '', 0, 1, 0, '20100101000000', 0, '', '', '');
SET IDENTITY_INSERT sv_user OFF;

INSERT INTO sv_user_server VALUES (1, 1);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES ('sv_chat',0,1,0);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES ('sv_vmail',10485760,1,0);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES ('sv_wboard',0,1,0);

INSERT INTO sv_plugin (id, filequota, server_id, usedquota) VALUES ('sv_query',0,1,0);

