
CREATE TABLE `sv_user` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `password` varchar(32) NOT NULL,
  `date_created` varchar(14) NOT NULL,
  `date_last_online` varchar(14) NOT NULL,
  `is_admin` int(11) NOT NULL DEFAULT '0',
  `is_anonymous` int(11) NOT NULL DEFAULT '0',
  `nickname` varchar(50) NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `server_id` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `expires` int(11) NOT NULL,
  `date_expires` varchar(14) NOT NULL,
  `extauth` int(11) NOT NULL,
  `extsource` varchar(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `info` varchar(500) NOT NULL,
  UNIQUE KEY `id` (`id`)
);

CREATE TABLE `plugin_sv_vmail_mails` (
  `mail_id` int(11) NOT NULL auto_increment,
  `subject` varchar(50) NOT NULL,
  `quality` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sender_id` int(11) NOT NULL,
  `size` int(11) NOT NULL,
  `date` varchar(14) NOT NULL,
  `unread` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY  (`mail_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `plugin_sv_vmail_mails_fk` FOREIGN KEY (`user_id`) REFERENCES `sv_user` (`id`)
);

CREATE TABLE `sv_server` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `description` text,
  `max_users` int(11) NOT NULL,
  `port` int(11) NOT NULL,
  `password` varchar(32) NOT NULL,
  `active` int(11) NOT NULL,
  `date_created` varchar(14) NOT NULL,
  `no_anonymous` int(11) NOT NULL default '0',
  `homepage_url` varchar(200) NOT NULL,
  `register` tinyint(4) NOT NULL,
  `list_on_svnetwork` tinyint(4) NOT NULL,
  `anon_role` int(11) NOT NULL,
  `reg_role` int(11) NOT NULL,
  `default_quality` int(11) NOT NULL,
  `default_codec` varchar(4) NOT NULL,
  `maintenance_mode` int(11) NOT NULL,
  `maintenance_message` varchar(200) NOT NULL,
  `maintenance_alt_server` varchar(50) NOT NULL,
  `redirect` varchar(50) NOT NULL,
  `redirect_active` int(11) NOT NULL,
  `banner_url` varchar(200) NOT NULL,
  `banner_link_url` varchar(200) NOT NULL,
  `banner_active` int(11) NOT NULL,
  `default_channel_id` int(11) NOT NULL,
  UNIQUE KEY `id` (`id`)
);

CREATE TABLE `sv_codec` (
  `id` varchar(4) NOT NULL,
  `quality` int(11) NOT NULL,
  `qualityname` varchar(50) NOT NULL,
  `server_id` int(11) NOT NULL,
  PRIMARY KEY (`id`,`quality`,`server_id`),
  KEY `sv_codec_fk` (`server_id`),
  CONSTRAINT `sv_codec_fk` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`)
);

CREATE TABLE `sv_ban` (
  `server_id` int(11) NOT NULL,
  `ip` varchar(18) NOT NULL,
  `date` varchar(14) NOT NULL,
  `banned_by` int(11) NOT NULL,
  `reason` varchar(50) NOT NULL,
  `endtime` varchar(14) NOT NULL,
  PRIMARY KEY  (`server_id`,`ip`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_ban_fk` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`)
);

CREATE TABLE `sv_channel` (
  `id` int(11) NOT NULL auto_increment,
  `parent_id` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  `max_users` int(11) NOT NULL default '0',
  `name` varchar(50) NOT NULL,
  `topic` varchar(200) NOT NULL,
  `description` text NOT NULL,
  `password` varchar(32) NOT NULL,
  `date_created` varchar(14) NOT NULL,
  `codec` varchar(4) NOT NULL,
  `quality` int(11) NOT NULL default '1',
  `admin_only` int(11) NOT NULL default '0',
  `no_anonymous` int(11) NOT NULL default '0',
  `no_temp_subchannels` int(11) NOT NULL default '0',
  `no_reg_subchannels` int(11) NOT NULL default '0',
  `no_admin_subchannels` int(11) NOT NULL default '0',
  `moderated` int(11) NOT NULL default '0',
  `hidden` int(11) NOT NULL default '0',
  `created_by` int(11) NOT NULL default '0',
  `type` int(11) NOT NULL default '1',
  `time_to_live` int(11) NOT NULL default '5',
  `position` int(11) NOT NULL default '0',
  `role_id` int(11) NOT NULL default '0',
  UNIQUE KEY `id` (`id`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_channel_fk` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`)
);

CREATE TABLE `sv_channel_ban` (
  `channel_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` varchar(14) NOT NULL,
  `banned_by` int(11) NOT NULL,
  `reason` varchar(50) NOT NULL,
  `endtime` varchar(14) NOT NULL,
  PRIMARY KEY  (`channel_id`,`user_id`),
  KEY `channel_id` (`channel_id`),
  CONSTRAINT `sv_channel_ban_fk` FOREIGN KEY (`channel_id`) REFERENCES `sv_channel` (`id`)
);

CREATE TABLE `sv_config` (
  `key` varchar(50) NOT NULL,
  `value` varchar(1000) NOT NULL,
  PRIMARY KEY  (`key`)
);

CREATE TABLE `sv_file` (
  `id` int(11) NOT NULL auto_increment,
  `plugin` varchar(50) NOT NULL,
  `path` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created` varchar(14) NOT NULL,
  `accessed` varchar(14) NOT NULL,
  `filelen` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  PRIMARY KEY  (`plugin`,`path`),
  UNIQUE KEY `id` (`id`),
  KEY `user_id` (`user_id`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_file_fk1` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`),
  CONSTRAINT `sv_file_fk` FOREIGN KEY (`user_id`) REFERENCES `sv_user` (`id`)
);

CREATE TABLE `sv_permissionlist` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(5) NOT NULL,
  `type` int(11) NOT NULL,
  `plugin` varchar(10) NOT NULL,
  `datatype` int(11) NOT NULL,
  `description` varchar(100) NOT NULL,
  `min_value` int(11) NOT NULL default '0',
  `max_value` int(11) NOT NULL default '1',
  PRIMARY KEY  (`id`)
);

CREATE TABLE `sv_plugin` (
  `id` varchar(50) NOT NULL,
  `filequota` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  `usedquota` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`,`server_id`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_plugin_fk` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`)
);

CREATE TABLE `sv_role` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `server_id` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_role_fk` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`)
);

CREATE TABLE `sv_rolepermission` (
  `role_id` int(11) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `may_execute` int(11) NOT NULL,
  `may_assign` int(11) NOT NULL,
  PRIMARY KEY  (`role_id`,`permission_id`),
  KEY `role_id` (`role_id`),
  KEY `permission_id` (`permission_id`),
  CONSTRAINT `sv_rolepermission_fk1` FOREIGN KEY (`permission_id`) REFERENCES `sv_permissionlist` (`id`),
  CONSTRAINT `sv_rolepermission_fk` FOREIGN KEY (`role_id`) REFERENCES `sv_role` (`id`)
);

CREATE TABLE `sv_user_role` (
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `channel_id` int(11) NOT NULL,
  PRIMARY KEY  (`user_id`,`role_id`,`channel_id`),
  KEY `user_id` (`user_id`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `sv_user_role_fk1` FOREIGN KEY (`role_id`) REFERENCES `sv_role` (`id`),
  CONSTRAINT `sv_user_role_fk` FOREIGN KEY (`user_id`) REFERENCES `sv_user` (`id`)
);

CREATE TABLE `sv_user_server` (
  `user_id` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  PRIMARY KEY  (`user_id`,`server_id`),
  KEY `user_id` (`user_id`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_user_server_fk1` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`),
  CONSTRAINT `sv_user_server_fk` FOREIGN KEY (`user_id`) REFERENCES `sv_user` (`id`)
);

CREATE TABLE `sv_vchannel` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL,
  `owner_id` int(11) NOT NULL,
  `server_id` int(11) NOT NULL,
  `shortcuts` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `owner_id` (`owner_id`),
  KEY `server_id` (`server_id`),
  CONSTRAINT `sv_vchannel_fk1` FOREIGN KEY (`server_id`) REFERENCES `sv_server` (`id`),
  CONSTRAINT `sv_vchannel_fk` FOREIGN KEY (`owner_id`) REFERENCES `sv_user` (`id`)
);

CREATE TABLE `sv_vchannel_member` (
  `vchannel_id` int(11) NOT NULL,
  `member_id` int(11) NOT NULL,
  `member_type` int(11) NOT NULL,
  PRIMARY KEY  (`vchannel_id`,`member_id`,`member_type`),
  KEY `vchannel_id` (`vchannel_id`),
  CONSTRAINT `sv_vchannel_member_fk` FOREIGN KEY (`vchannel_id`) REFERENCES `sv_vchannel` (`id`)
);

CREATE TABLE `sv_voicegroup` (
  `id` int(11) NOT NULL auto_increment,
  `channel_id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `password` varchar(32) NOT NULL,
  `role_id` int(11) NOT NULL,
  `created_by` int(11) NOT NULL,
  `date_created` varchar(14) NOT NULL,
  `moderated` int(11) NOT NULL,
  `hidden` int(11) NOT NULL,
  `no_anonymous` int(11) NOT NULL,
  `admin_only` int(11) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `channel_id` (`channel_id`),
  CONSTRAINT `sv_voicegroup_fk` FOREIGN KEY (`channel_id`) REFERENCES `sv_channel` (`id`)
);

CREATE TABLE `sv_voicegroupkey` (
  `user_id` int(11) NOT NULL,
  `voicegroup_id` int(11) NOT NULL,
  `shortcuts` varchar(50) NOT NULL,
  PRIMARY KEY  (`user_id`,`voicegroup_id`),
  KEY `user_id` (`user_id`),
  KEY `voicegroup_id` (`voicegroup_id`),
  CONSTRAINT `sv_voicegroupkey_fk1` FOREIGN KEY (`voicegroup_id`) REFERENCES `sv_voicegroup` (`id`),
  CONSTRAINT `sv_voicegroupkey_fk` FOREIGN KEY (`user_id`) REFERENCES `sv_user` (`id`)
);



INSERT INTO `sv_server` (`id`, `name`, `description`, `max_users`, `port`, `password`, `active`, `date_created`, `no_anonymous`, `homepage_url`, `register`, `list_on_svnetwork`, `anon_role`, `reg_role`, `default_codec`, `default_quality`, `maintenance_mode`, `maintenance_message`, `maintenance_alt_server`, `redirect`, `redirect_active`, `banner_url`, `banner_link_url`, `banner_active`) VALUES 
  (1,'Mainserver','',256,8040,'',1,'20070101000000',0,'http://www.shockvoice.org',0,0,0,0,'SPEX',8,0,'','','',0,'','',0);

INSERT INTO `sv_user` (`id`, `name`, `password`, `date_created`, `date_last_online`, `is_admin`, `is_anonymous`, `nickname`, `ip_address`, `server_id`, `active`, `expires`, `date_expires`, `extauth`, `extsource`, `email`, `info`) VALUES 
  (1, 'admin', '21232f297a57a5a743894a0e4a801fc3', '20100101000000', '20100101000000', 1, 0, '', '', 0, 1, 0, '20100101000000', 0, '', '', '');

INSERT INTO `sv_user_server` (`user_id`, `server_id`) VALUES
  (1, 1);

INSERT INTO `sv_plugin` (`id`, `filequota`, `server_id`, `usedquota`) VALUES 
  ('sv_chat',0,1,0);

INSERT INTO `sv_plugin` (`id`, `filequota`, `server_id`, `usedquota`) VALUES 
  ('sv_vmail',10485760,1,0);

INSERT INTO `sv_plugin` (`id`, `filequota`, `server_id`, `usedquota`) VALUES 
  ('sv_wboard',0,1,0);

INSERT INTO `sv_plugin` (`id`, `filequota`, `server_id`, `usedquota`) VALUES 
  ('sv_query',0,1,0);

INSERT INTO `sv_config` (`key`, `value`) VALUES 
  ('DB_VERSION','0.9');

