<?php

require_once('lib/nusoap.php');

class SvSoap
{
    private $client;

    function __construct($wsdl, $user, $password, $url)
    {
	$this->client = new nusoap_client($wsdl, 'wsdl');
	$this->client->setCredentials($user, $password);
	$this->client->setEndpoint($url);
    }
    
    function call($function, $param)
    {
	$result = $this->client->call($function, array('parameters' => $param), '', '', false, true);

	if ($this->client->fault) 
	{
	    echo '<h2>Fault</h2><pre>';
	    print_r($result);
	    echo '</pre>';
	} 
	else 
	{
	    $err = $this->client->getError();
	    if ($err) 
	    {
		echo '<h2>Error</h2><pre>' . $err . '</pre>';
	    } 
	}
	
	return $result;
    }
    
    function serverStart($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id, 
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverStart', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverStartResult'][1];    
    }
    
    function serverStop($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id, 
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverStop', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverStop'][1];
    }
    
    function serverReload($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id, 
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverReload', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverReloadResult'][1];
    }

    function serverCreate($name, $description, $password, $max_users, $port, $no_anonymous,
	$active, $homepage, $register, $list_on_svn, &$newserver_id, &$message, &$errors)
    {
	$param = array(
		'name' => $name,
		'description' => $description,
		'password' => $password,
		'max_users' => $max_users,
		'port' => $port,
		'no_anonymous' => $no_anonymous,
		'active' => $active,
		'homepage' => $homepage,
		'register' => $register,
		'list_on_svn' => $list_on_svn,
		'newserver_id' => '',
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverCreate', $param);
	
	$newserver_id = $result['newserver_id'];
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverCreateResult'][1];
    }
    
    function serverCreateDefaultChannels($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverCreateDefaultChannels', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverCreateDefaultChannelsResult'][1];
    }

    function serverCreateDefaultRoles($server_id, $roles, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'roles' => $roles,
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverCreateDefaultRoles', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverCreateDefaultRolesResult'][1];
    }
    
    function serverModify($server_id, $name, $description, $max_users, $port, $no_anonymous,
	$active, $homepage, $register, $list_on_svn, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'name' => $name,
		'description' => $description,
		'max_users' => $max_users,
		'port' => $port,
		'no_anonymous' => $no_anonymous,
		'active' => $active,
		'homepage' => $homepage,
		'register' => $register,
		'list_on_svn' => $list_on_svn,
		'message' => '', 
		'errors' => '');
		
	$result = $this->call('serverModify', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverModifyResult'][1];
    }
    
    function serverSetBanner($server_id, $banner_active, $banner_url, $banner_link_url, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'banner_active' => $banner_active,
		'banner_url' => $banner_url,
		'banner_link_url' => $banner_link_url,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('serverSetBanner', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverSetBannerResult'][1];
    }
    
    function serverClone($server_id, $name, $port, &$newserver_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'name' => $name,
		'port' => $port,
		'newserver_id' => '',
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('serverClone', $param);
	
	$newserver_id = $result['newserver_id'];
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverCloneResult'][1];
    }
    
    function serverDelete($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('serverDelete', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverDeleteResult'][1];
    }
    
    function serverList(&$message, &$errors)
    {
	$param = array(
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('serverList', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['serverListResult'][1];
    }
    
    function pluginActivate($server_id, $plugin_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'plugin_id' => $plugin_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('pluginActivate', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['pluginActivateResult'][1];
    }
    
    function pluginDeactivate($server_id, $plugin_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'plugin_id' => $plugin_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('pluginDeactivate', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['pluginDeactivateResult'][1];
    }
    
    function pluginSetQuota($server_id, $plugin_id, $quota, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'plugin_id' => $plugin_id,
		'quota' => $quota,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('pluginSetQuota', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['pluginSetQuotaResult'][1];
    }
    
    function pluginList($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('pluginList', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['pluginListResult'][1];
    }
    
    function roleFind($name, $server_id, &$role_id, &$message, &$errors)
    {
	$param = array(
		'name' => $name,
		'server_id' => $server_id,
		'role_id' => '',
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleFind', $param);
	
	$role_id = $result['role_id'];
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleFindResult'][1];
    }
    
    function roleCreate($name, $server_id, &$newrole_id, &$message, &$errors)
    {
	$param = array(
		'name' => $name,
		'server_id' => $server_id,
		'newrole_id' => '',
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleCreate', $param);
	
	$role_id = $result['newrole_id'];
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleCreateResult'][1];
    }
    
    function roleModify($role_id, $name, &$message, &$errors)
    {
	$param = array(
		'role_id' => $role_id,
		'name' => $name,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleModify', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleModifyResult'][1];
    }
    
    function roleDelete($role_id, &$message, &$errors)
    {
	$param = array(
		'role_id' => $role_id, 
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleDelete', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleDeleteResult'][1];
    }
    
    function roleAssign($role_id, $user_id, $channel_id, &$message, &$errors)
    {
	$param = array(
		'role_id' => $role_id,
		'user_id' => $user_id,
		'channel_id' => $channel_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleAssign', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleAssignResult'][1];
    }
    
    function roleRevoke($role_id, $user_id, $channel_id, &$message, &$errors)
    {
	$param = array(
		'role_id' => $role_id,
		'user_id' => $user_id,
		'channel_id' => $channel_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleRevoke', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleRevokeResult'][1];
    }
    
    function roleSetPermission($role_id, $permission_name, $assign, $execute, &$message, &$errors)
    {
	$param = array(
		'role_id' => $role_id,
		'permission_name' => $permission_name,
		'assign' => $assign,
		'execute' => $execute,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleSetPermission', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleSetPermissionResult'][1];
    }
    
    function roleList($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('roleList', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['roleListResult'][1];
    }
    
    function userCreate($name, $password, $isadmin, $server_id, &$newuser_id, &$message, &$errors)
    {
	$param = array(
		'name' => $name,
		'password' => $password,
		'isadmin' => $isadmin,
		'server_id' => $server_id,
		'newuser_id' => '',
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('userCreate', $param);
	
	$newuser_id = $result['newuser_id'];
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['userCreateResult'][1];
    }
    
    function userModify($user_id, $password, $isadmin, $server_id, &$message, &$errors)
    {
	$param = array(
		'user_id' => $user_id,
		'password' => $password,
		'isadmin' => $isadmin,
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('userModify', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['userModifyResult'][1];
    }
    
    function userDelete($user_id, &$message, &$errors)
    {
	$param = array(
		'user_id' => $user_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('userDelete', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['userDeleteResult'][1];
    }
    
    function userClone($user_id, $server_id, $newname, $newpassword, &$newuser_id, &$message, &$errors)
    {
	$param = array(
		'user_id' => $user_id,
		'server_id' => $server_id,
		'newname' => $newname,
		'newpassword' => $newpassword,
		'newuser_id' => '',
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('userClone', $param);
	
	$newuser_id = $result['newuser_id'];
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['userCloneResult'][1];
    }
    
    function userList($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('userList', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['userListResult'][1];
    }
    
    function codecAdd($server_id, $codecname, $quality, $qualityname, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'codecname' => $codecname,
		'quality' => $quality,
		'qualityname' => $qualityname,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('codecAdd', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['codecAddResult'][1];
    }
    
    function codecRemove($server_id, $codecname, $quality, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'codecname' => $codecname,
		'quality' => $quality,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('codecRemove', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['codecRemoveResult'][1];
    }
    
    function codecRemoveAllQualities($server_id, $codecname, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'codecname' => $codecname,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('codecRemoveAllQualities', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['codecRemoveAllQualitiesResult'][1];
    }
    
    function codecReplace($server_id, $oldcodecname, $oldquality, $newcodecname, $newquality, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'oldcodecname' => $oldcodecname,
		'oldquality' => $oldquality,
		'newcodecname' => $newcodecname,
		'newquality' => $newquality,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('codecReplace', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['codecReplaceResult'][1];
    }
    
    function codecList($server_id, &$message, &$errors)
    {
	$param = array(
		'server_id' => $server_id,
		'message' => '', 
		'errors' => '');
	
	$result = $this->call('codecList', $param);
	
	$message = $result['message'];
	$errors = $result['errors'];
	
	return $result['codecListResult'][1];
    }
    
}

?>
